<?php 
    /**
    *
    * copyright (c) 2013-2021 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "../include/includeBaseComponenti.php";
    include "../../../template/stile.php";
    
    if(isset($_GET["id"])) {
        $video = $geecomDb->leggiSingolaRiga("geec_video",filter_input(INPUT_GET,"id",FILTER_SANITIZE_NUMBER_INT));
    }
?>
<!doctype html>
<html lang="en">
    <head>
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

        <?php
            include "../include/cssBaseComponenti.php";
        ?>
        <title>Geecom CMS - creazione video</title>
    </head>
    <body>
    
        <header>
            <?php 
                include "../../include/barraSuperiore.php";

                include "../../include/header.php";

                include "../../include/barraMenu.php";
            ?>
        </header>

        <main role="main" class="bg-light" id="main">
            <div class="container-fluid">

                <?php 
                    if(isset($_GET["status"])) {
                        $status = filter_input(INPUT_GET,"status",FILTER_SANITIZE_NUMBER_INT);
                    }
                    else {
                        $status = 0;
                    }

                ?>
                <form name="formElemento" action="controller/controllerVideo.php" method="post">
                    <div class="row py-4">
                        <?php 
                            if($status==200) {
                                echo"<div class=\"col-12\">
                                        <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                            Elemento modificato
                                            <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                                  <span aria-hidden=\"true\">&times;</span>
                                            </button>
                                        </div>
                                    </div>";
                            }
                            else if($status==210) {
                                 echo"<div class=\"col-12\">
                                        <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                            Video duplicato, modificalo per non avere due video uguali
                                            <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                                  <span aria-hidden=\"true\">&times;</span>
                                            </button>
                                        </div>
                                    </div>";
                            }
                        ?>
                        
                        <div class="col-12">
                            <div class="form-row justify-content-between mb-3">
                                <div class="col-auto d-flex">
                                    <nav aria-label="breadcrumb" class="align-self-center">
                                        <ol class="breadcrumb p-0 mb-1 mb-md-0 bg-transparent">
                                            <li class="breadcrumb-item"><a href="../../home.php">Home</a></li>
                                            <li class="breadcrumb-item"><a href="#" data-toggle="modal" data-target="#menu-componenti">Componenti</a></li>
                                            <li class="breadcrumb-item"><a href="index.php">Video</a></li>
                                            <li class="breadcrumb-item active" aria-current="page"><?php echo((isset($video)? $video["nome"] : "Nuovo video"))?></li>
                                        </ol>
                                    </nav>
                                </div>
                                <div class="col-auto text-right">
                                    <a class="btn btn-outline-primary" href="index.php"><i class="fas fa-arrow-left mr-2"></i>Torna all'elenco</a>
                                    <button class="btn btn-primary" onclick="document.formComponente.submit()"><i class="fas fa-check"></i> Salva</button>
                                    <?php 
                                        if(isset($video)) {
                                    ?>
                                        <button type="button" class="btn btn-warning mt-2 mt-lg-0" onclick="location.href='controller/controllerVideo.php?id=<?php echo $video["id"] ?>&operazione=duplica';"><i class="far fa-clone mr-2"></i>Duplica</button>
                                    <?php
                                        }
                                    ?>
                                </div>
                            </div>
                            <div class="card mb-4 box-shadow-lite">
                                    
                                    <input type="text" class="d-none" name="operazione" value="<?php echo((isset($video) ? "modifica" : "crea")); ?>">
                                    <input type="text" class="d-none" name="id" value="<?php echo((isset($video) ? $video["id"] : "0")); ?>">

                                    <div class="card-body">
                                        <div class="row">
                                            
                                            <div class="col-lg-7">
                                                <div class="row">
                                                    <div class="col-12 form-group">
                                                        <label>Nome</label>
                                                        <input type="text" class="form-control" id="nomeSlider" name="nome" aria-describedby="titolo video" value="<?php echo((isset($video) ? $video["nome"] : "")) ?>" placeholder="Titolo video">
                                                    </div>

                                                    <div class="col-md-4 form-group">
                                                        <label>Spazio occupato</label>
                                                        <select class="form-control" name="spazioOccupato">
                                                        <?php 
                                                            foreach($arrayDimensioniColonna as $classe=>$descrizione) {
                                                                if(isset($video) && $video["spazioOccupato"]==$classe) {
                                                                    echo"<option value=\"$classe\" selected>$descrizione</option>";
                                                                }
                                                                else {
                                                                    echo"<option value=\"$classe\">$descrizione</option>";
                                                                }
                                                            }
                                                        ?>
                                                        </select>
                                                        <small class="text-muted">Scegli lo spazio che deve occupare il video nella sezione</small>
                                                    </div>
                                                    
                                                    <div class="form-group col-md-8">
                                                        <label for="titolo-articolo">Link video</label>
                                                        <input  type="text" class="form-control" name="video" value="<?php echo((isset($video)? $video["video"] : ""))?>" placeholder="Link video">
                                                        <small class="text-muted">Usa un link (es https://www.youtube.com/embed/ZCt97lt9XcM) oppure carica un video</small>
                                                    </div>

                                                </div>   
                                            </div><!--/Colonna principale -->
                                        </form>
                                        <!--Colonna secondaria -->
                                        <div class="col-lg-5 pb-4 align-self-start sticky-top">
                                           
                                           <div class="card mb-3 rounded-0 box-shadow-lite">
                                               <div class="card-header">
                                                   <div class="card-title mb-0">
                                                       Video
                                                   </div>
                                               </div>
                                               <div class="card-body">
                                                   <div class="mb-3">
                                                       <?php 
                                                           if(isset($video) && $video["video"]!="" && strpos($video["video"],"https")===false) {
                                                       ?>
                                                               <div class="embed-responsive embed-responsive-16by9 mb-3">
                                                                   <video src="../../../<?php echo $video["video"] ?>" controls ></video>
                                                               </div>
                                                       <?php
                                                           }
                                                           else if(isset($video) && strpos($video["video"],"https")===0) {
                                                       ?>
                                                               <div class="embed-responsive embed-responsive-16by9">
                                                                   <iframe class="embed-responsive-item" src="<?php echo $video["video"] ?>"></iframe>
                                                               </div>
                                                       <?php
                                                           }
                                                       ?>
                                                   </div>
                                                   <form action="controller/controllerVideo.php" id="frmFileUpload-00" class="dropzone singolo-file" method="post" enctype="multipart/form-data">
                                                       <div class="dz-message">
                                                           <i class="fas fa-file-upload fa-2x mb-2"></i>
                                                           <h5>Trascina o carica video</h5>
                                                       </div>
                                                       <div class="fallback">
                                                           <input name="file" type="file" />
                                                       </div>
                                                   </form>
                                               </div>
                                           </div>
                                       </div><!--/Colonna secondaria -->
                                        </div>
                                    </div>
                                    <div class="card-footer">
                                        <button type="button" class="btn btn-primary float-right" onclick="document.formElemento.submit()"><i class="fas fa-check"></i> Salva</button>
                                    </div>
                                </div>
                            </div>
                        
                            </div>
                        </div>
           
                    </form>

                </div>
            </div>
        </main>

        <?php 
            include "../../include/footer.php";

            include "../include/modal/cambiaPassword.php";

            include "../../include/modal/modalMenuComponenti.php";

            include "../../include/modal/operazioneCompletata.php";

            include "../include/jsBaseComponenti.php";
        ?>
        
        <!-- Dropzone -->
        <script type="text/javascript" src="../../../plugins/dropzone/dropzone.js"></script>
        <script>
            $(".singolo-file").dropzone({
                acceptedFiles: ".mp4,.avi",
                maxFiles: 1,
                addRemoveLinks: true,
                dictRemoveFile: "Rimuovi",
                success: function(file,response) {
                    location.reload();
                    this.removeAllFiles();
                },
                params:{
                    operazione:"modificaFileVideo",
                    id:<?php echo(isset($video) ? $video["id"] : 0) ?>
                },
                maxfilesexceeded: function(file) {
                    this.removeAllFiles();
                    this.addFile(file);
                }
            })
        </script>

    </body>
</html>
